//***************************************************************************************
// HelloWorld.c
// 
// APSC1299 first project. Note SparkFun LCD must be connected to power and the 
// signal lead connected to pin 25 TX on the breadboard.  
//
// Dan Peirce & Mike Coombes, May 2010. 
// Updated Feb 2013
// Update Sept 2014
//
//***************************************************************************************
 
#include <stdio.h>          // library containing printf() function
#include <xc.h>
#include "..\Common\osc.h"            // library for set_osc_32MHz()
#include "..\Common\configureUSART.h" // library for configureUSART(baud)


// These are not C statements but directives to the C18 compiler. They result in configuration
// bits in the PIC18F4525 being set in the flash memory. This configuration is set when the 
// PIC is programmed by the PICkit2 programmer and before any program starts to run in the PIC.

#pragma config WDT = OFF
#pragma config OSC = INTIO7      // puts osc/4 on pin 14 to check freq
#pragma config MCLRE = OFF
#pragma config LVP = OFF
#pragma config PBADEN = OFF      // PORTB<4:0> are digital IO 


void WaitOneSecond(void);
void WaitQuarterSecond(void);

void main(void)  // a C project can only have one main() function
{
    char string[] = "    APSC1299    "; // 16 chars wide to fill bottom line of LCD
	
    set_osc_32MHz(); // set MCU to run at 32 MHz
					 // fOSC = 32 000 000 Hz
                     // TOSC = 1/32 000 000 s = 31.25 ns
                     // TCY = 4*TOSC = 125 ns 	
    configureUSART(9600ul, 32); // configure MCU serial communication module to run at 9600 baud 
                                // with MCU operating at 32 MHz. Defined in configureUSART.c
        		        // 9600 bits/s is default communication rate
                		// other choices 2 400, 4 800, 19 200, 38 400 (not available at 1 MHz)
                                // LCD will not work if MCU is not configured for USART    

    _delay(100000ul);
    _delay(100000ul);
    _delay(100000ul);
    _delay(100000ul);
    _delay(100000ul); // small delay to wait for splash screen to appear  
 //////////////////////////////////////////////////////////////////////////////////////////
 //   printf("%c",0x12);  // reset LCD to default 9600 bps
 //                       // only works if run during splash screen.
 //                       // use only in case LCD was accidently set to another baud rate
 //			  // and is printing garbage
 //   WaitOneSecond();    // Wait for reset message to complete   
 //                       // LCD will not respond to printf() until it is finished.
 ///////////////////////////////////////////////////////////////////////////////////////////
    WaitOneSecond();   // The splash screen lasts about one second
                       // LCD will not respond to printf() until it is finished.
   
    printf("%c%c",0xFE,0x01); //Command - clear and zero display
                              //Not strictly necessary since splash clears itself  
    printf("   Hello World  "); // 16 chars wide to fill top line of LCD
    WaitOneSecond();
    WaitOneSecond();
    printf("%s",string); // 16 chars wide to fill bottom line of LCD
    WaitOneSecond();
    WaitOneSecond();

    while(1)
    {
        // MCUs run continuously so an endless loop is required.
        // Jiggle Message.
        printf("%c%c",0xFE, 0x1C); //move message right one column
        WaitQuarterSecond(); 
        printf("%c%c",0xFE, 0x18); //move message left one column
        WaitQuarterSecond();
    }	

}

void WaitOneSecond(void)
{
int  i = 0;
for(i=0; i<=80; i++) 
   {
    _delay(100000ul);  // 100 000 * 4 / 32 000 000 = 1/80 s 
   }
}

void WaitQuarterSecond(void)
{
int  i = 0;
for(i=0; i<=20; i++) 
   {
    _delay(100000ul);  // 100 000 * 4 / 32 000 000 = 1/80 s 
   }
}

