#include <xc.h>         // library of functions for this chip 
#include <stdio.h>      // library containing printf() function


void printCharAsBinary(unsigned char number);
void WaitOneSecond(void);

int main(void)  
{
    unsigned i = 0;
    configureUSART(9600ul, 1); // configure MCU serial communication module to run at 9600 baud 
                               // defined in configureUSART.c

    WaitOneSecond();   // The splash screen lasts about one second
                       // LCD will not respond to printf() until it is finished.



    for(i=0; i < 256; i++)
      {
	printf("\n\r %u = ",i);
        printCharAsBinary((unsigned char)i);
        
      }                         

while(1)
   {
	  // MCUs run continuously so an endless loop is required.
   }
}	


void printCharAsBinary(unsigned char number)
{

if ( ((number & 0b10000000) >> 7 ) == 1)
   printf("0b1");
else
   printf("0b0");

if ( ((number & 0b01000000) >> 6 ) == 1)
   printf("1");
else
   printf("0");


if ( ((number & 0b00100000) >> 5 ) == 1)
   printf("1");
else
   printf("0");


if ( ((number & 0b00010000) >> 4 ) == 1)
   printf("1");
else
   printf("0"); 


if ( ((number & 0b00001000) >> 3 ) == 1)
   printf("1");
else
   printf("0");


if ( ((number & 0b00000100) >> 2 ) == 1)
   printf("1");
else
   printf("0");

if ( ((number & 0b00000010) >> 1 ) == 1)
   printf("1");
else
   printf("0");


if ( ((number & 0b00000001) ) == 1)
   printf("1");
else
   printf("0");

}


void WaitOneSecond(void)
{
int  i = 0;
for(i=0; i<=5; i++) 
   {
    _delay(50000ul);  // 50 000 * 4 / 1 000 000 = 1/5 s 
   }
}