//***************************************************************************************
// breakpoints.c
// 
// Debugging tools
//
//***************************************************************************************

#include <xc.h>         // library of functions for this chip 
#include <stdio.h>      // library containing printf() function

#include "..\Common\osc.h"                // library for set_osc_32MHz()
#include "..\Common\configureUSART.h"     // library for configureUSART()
#include "..\Common\configuration_bits.h" // default config

# define _XTAL_FREQ 32000000  // operating at 32 MHz 


void main(void)  
{
    char a = 57, b = 23;
    char c;

    int d = 57, e = 23;
    int f;

    set_osc_32MHz(); 	
    configureUSART(9600ul, 32); // configure MCU serial communication module to run at 9600 baud 
                               // defined in configureUSART.c
                         
    // Section A - "watch" bitwise operations. Best to view in binary.
    c = a & b;
    c = a | b;
    c = a ^ b;
    c = a >> 3;
    c = c << 2;
    c = ~a;
    NOP();

    // Section B - timing addition of char and int with Stopwatch
    c = a + b;
    f = d + e;
    NOP();

    // Section C - timing 9 delays with Stopwatch
    _delay(1000);            //1
    _delay(10000)            //2 
    _delay(100000ul);        //3
    _delay(200000ul);        //4 will generate error
    _delay3(100);            //5
    _delay3(400);            //6
    _delay3(0);              //7
    __delays_ms(12.5);       //8
     NOP(); 		     //9

	while(1)
	   {
		  // MCUs run continuouslly so an endless loop is required.
	   }
}	
