/*                                                          */
/*  LED brightness or motor speed control using PWM         */
/*                                                          */
/*  Connect 2Way LED between CCP1 and either RB0 or RB1     */ 

#include <xc.h>
#include "..\Common\osc.h"
#include "..\Common\configuration_bits.h"


void main(void)
{
    set_osc_32MHz();         // Set oscillator to 32 MHz, TOSC = 31.25 ns.

    TRISBbits.RB0 = 0;    // Pin RB0 is an output
    TRISBbits.RB1 = 0;    // Pin RB1 is an output
    PORTBbits.RB0 = 0;       // Pin RB0 is low - off
    PORTBbits.RB1 = 1;       // Pin RB1 is high - on

    OpenTimer2(T2_PS_1_16);  // TMR2 prescale is 16
    OpenPWM1(199);           // TPWM = (199+1)*4*(31.25 ns)*16
                         //      = 0.400 ms
    SetDCPWM1(144);           // TDC  = 144*(31.25 ns)*16
                         //      = 0.072 ms
                         //      = 18% * TPWM

    //Pin 17 is now generating a square wave.

    while(1);

}
