// SoftToggle.c monitor a digital input pin on RD1 using rising edges.
//
// Usually connect a button to this pin but any square wave input will do. 
//
// Barebones code. Lots to add to make it do something useful
//
// Revised Feb, 2014 

#include <xc.h>
#include "buttons.h"  // has monitor_switch1_for_edges()

void switch1_risingedge_action(void); 
void switch1_fallingedge_action(void); 

void main(void) 
{ 
    unsigned char has_switch1_changed = 0;
    TRISDbits.RD1 = 1; // set RD1 as input (switch 1)

    while(1) 
    { 
      has_switch1_changed = monitor_switch1_for_edges(PORTDbits.RD1);
      if ( has_switch1_changed == 1 ) switch1_risingedge_action();
      if ( has_switch1_changed == 2 ) switch1_fallingedge_action();
    } 
} 



void switch1_risingedge_action(void) 
{ 
    // do something useful or leave blank 
}

void switch1_fallingedge_action(void) 
{ 
    // do something useful or leave blank
}

// end program
