﻿// Demonstrates how to use the Timer0 module to control the
// on off times of an LED between RB0 and RB1 while still allowing 
// the program to monitor a button press on RD1 to control current
// direction. Use with a 2-way LED.
// 
// Please note that this is not the most efficient way to use timers.
// How could we make the could more efficient?
//
// Barebones codes. Lots to add for it to function appropriately.

#include <xc.h>
#include "..\Common\buttons.h"

void switch_LEDcolour(void); 


void main(void)
{
    unsigned char has_switch1_changed  = 0;

    set_osc_32MHz();       // select 32 MHz oscillator speed

    TRISBbits.RB0 = 0;  // Configure as an output for an LED
    TRISBbits.RB1 = 0;  // Configure as an output for an LED
    
    TRISDbits.RD1 = 1;  // Configure as an button

    PORTBbits.RB0 = 0;     // port is low (0)
    PORTBbits.RB1 = 0;     // port is low (0)

    while(1)
    {
        // on (duty cycle) portion of pulse
                        
        OpenTimer0(TIMER_INT_OFF & T0_SOURCE_INT & T0_16BIT & T0_PS_1_32);

        TMR0IF = 0; // clear the flag before use
        PORTBbits.RB0 ^= 1;    // switch polarity - LED on (same as PORTBbits.RB0 != PORTBbits.RB0)
        WriteTimer0(25536u);
        while(!TMR0IF)
        {
            //This runs for (65536 - 25536)x32xTcy = 0.16 s
            has_switch1_changed = monitor_switch1_for_edges(PORTDbits.RD1);
            if (has_switch1_changed == 1) switch_LEDcolour(); 
        }

     
        // off portion of pulse
        // will use alternate method of timing using ReadTimer0 rather than interrupt
        // note: you can change prescalar anytime
        OpenTimer0(TIMER_INT_OFF & T0_SOURCE_INT & T0_16BIT & T0_PS_1_16);
     

        PORTBbits.RB0 ^= 1;    // switch polarity - LED off
        WriteTimer0(0);
        while( ReadTimer0() < 40000u )
        {
            //This runs for (40000 - 0)x16xTcy = 0.08 s
            has_switch1_changed = monitor_switch1_for_edges(PORTDbits.RD1);
            if (has_switch1_changed == 1) switch_LEDcolour();      
        }

    }
}



void switch_LEDcolour(void) 
{ 
    //switch polarity of both pins to change current direction and LED colour
    PORTBbits.RB0 ^= 1;
    PORTBbits.RB1 ^= 1;
}

